const mysql = require("mysql2/promise");
const { dbConnect } = require("../settings");

const connectionOptions = {
  host: dbConnect.DB_HOST,
  user: dbConnect.DB_USERNAME,
  password: dbConnect.DB_USERNAME_PASSWORD,
  database: dbConnect.DB_NAME,
};

const pool = mysql.createPool(connectionOptions);

const connectToMySQL = async () => {
  try {
    const connection = await pool.getConnection();
    console.log("MySQL database connected!");

    connection.release();
  } catch (err) {
    console.error("MySQL database connection error:", err.message);
    process.exit(1);
  }
};

connectToMySQL();

module.exports = pool;